/*
 * Decompiled with CFR 0.152.
 */
package com.conbifan.joinleavemessages;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class JoinLeaveMessages
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private String joinMessage;
    private String quitMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadPluginConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("The JoinLeaveMessages plugin has been enabled.");
    }

    public void onDisable() {
        this.getLogger().info("The JoinLeaveMessages plugin has been disabled.");
    }

    private void reloadPluginConfig() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.joinMessage = this.config.getString("messages.join", "&e{player} has joined the server.");
        this.quitMessage = this.config.getString("messages.leave", "&e{player} has left the server.");
        this.getLogger().info("joinMessage: " + this.joinMessage);
        this.getLogger().info("quitMessage: " + this.quitMessage);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        event.setJoinMessage(null);
        Bukkit.broadcastMessage((String)this.formatMessage(this.joinMessage, player));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        event.setQuitMessage(null);
        Bukkit.broadcastMessage((String)this.formatMessage(this.quitMessage, player));
    }

    private String formatMessage(String rawMessage, Player player) {
        if (rawMessage == null || player == null) {
            return "";
        }
        int onlineCount = Bukkit.getOnlinePlayers().size();
        return ChatColor.translateAlternateColorCodes((char)'&', (String)rawMessage.replace("{player}", player.getName()).replace("{displayname}", player.getDisplayName()).replace("{world}", player.getWorld().getName()).replace("{online}", String.valueOf(onlineCount)));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("jlreload")) {
            if (!sender.hasPermission("joinleavemessages.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            this.reloadPluginConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "JoinLeaveMessages configuration reloaded!");
            return true;
        }
        return false;
    }
}

